<?php


class Pages extends CI_Controller {

	public function __construct()
    {
            parent::__construct();
            $this->load->model('Pages_model');
            $this->load->library("pagination");
            if(!$this->session->userdata('logged_in')){
                redirect('login','refresh');
                return;
            }
    }
    
	public function index(){
        if($this->session->userdata('logged_in')){
    		$datos = array(
    			'section_title' => 'Bienvenido al Administrador de mSalud',
    			'section_page' => 'inicioAdmin',
    			);
    		$this->load->view('administrador', $datos);
        }
	}



	public function login(){
		$this->load->view('login');
	}


   /*============================== Reporte completo de los participantes=================================================*/

    public function reporteCompleto()
    {
        $datos = array(
        'section_title' => 'Bienvenido al Administrador de mSalud',
        'section_page'  => 'reporteCompleto',
        'participantes'=>$this->Pages_model->getParticipantes()
        );
		$this->load->view('administrador', $datos);
    }
    
    /*============================== Registro de incompletos =================================================*/

    public function registrosIncompletos()
    {
        $datos = array(
       'section_title' => 'Bienvenido al Administrador de mSalud',
       'section_page'  => 'registrosIncompletos',
       'participantes' => $this->Pages_model->getIncompletos()
       );
       $this->load->view('administrador', $datos);
   }
    
    
     /*============================== obtenemos el listado de la tabla muestra=================================================*/

    public function getMuestra()
    {
        $datos = array(
        'section_title' => 'Bienvenido al Administrador de mSalud',
        'section_page'  => 'vermuestra',
        'muestra'=>$this->Pages_model->getMuestra()
        );
		$this->load->view('administrador', $datos);
    }
    
    

     /*============================== Reporte completo de las sugerencias=================================================*/

    public function getSugerencias()
    {
        $datos = array(
            'section_title' => 'Bienvenido al Administrador de mSalud',
            'section_page'  => 'Sugerencias',
            'sugerencias'=>$this->Pages_model->getSugerencias()
            );
        $this->load->view('administrador', $datos);

    }


    /*=============================== Muestra la vista para seleccionar una muestra ================================================*/

    public function muestra(){
        $muestra= null;
        $Cant = $this->input->post('cantidad_ganadores');
        if ($this->input->post('sortear')){
             $Cant = $this->input->post('cantidad_ganadores'); 
             
             if ($Cant) {
                 $muestra=  $this->Pages_model->filtrarMuestra($Cant);
                  $datos = array(
                    'section_title' => 'Bienvenido al Administrador',
                    'section_page'  => 'muestra',
                    'participantes'     => $muestra,
                    'cantidad'      => $Cant,
                    );
                    $this->load->view('administrador', $datos);
             }else{
                $this->session->set_flashdata('error', '<strong></strong> Digite la cantidad de ganadores');
                     redirect ('muestra', 'refresh');
             }
        }else if ($this->input->post('confirmar_ganadores')){
          $muest=$this->input->post('participantes');
          $this->Pages_model->confirmarMuestra($muest);
         
            $datos = array(
                    'section_title' => 'Bienvenido al Administrador',
                    'section_page'  => 'muestra',
                    'participantes'     => null,
                    'cantidad'      => null,
                    );
            $this->session->set_flashdata('success', 'true');
            $this->load->view('administrador', $datos);

        }else{
            $datos = array(
            'section_title' => 'Bienvenido al Administrador de Pampers',
            'section_page'  => 'muestra',
            'participantes'     => $muestra,
            'cantidad'      => $Cant,
            );
              $this->load->view('administrador', $datos);
        }
    }


	function logout(){

	   $this->session->unset_userdata('logged_in');
	   session_destroy();
	   redirect('login', 'refresh');
	 }
	
	
	public function getModulo()
	{
	    $idParticipante=$_GET['idParticipante'];
	    $datos = array(
        'module'=>$this->Pages_model->getModulo($idParticipante),
        'section_page'  => 'modulo',
        'idParticipante'=>$idParticipante
        );
	    $this->load->view('administrador',$datos);
	}

	
}
