 <?php

class Api_model extends CI_Model{
    
    
    function __construct(){
		date_default_timezone_set('America/Costa_Rica');
	}
	
	
	/**_________________________________________________________Obtenemos todas las Provincias__________________________________*/
	
	//
	public function getProvincias(){
	    $query = $this->db->get('provincia');
		if ($query->num_rows() > 0){
			return $query->result();
		}else{
			return false;
		}
	}
	
	public function limpiarTablaSessions(){
	    $this->db->truncate('ci_sessions');
	}
	

	//
	public function getCantones($codigoProvincia){
	    $query = $this->db->get_where('canton',array('codigo_provincia'=>$codigoProvincia));
		if ($query->num_rows() > 0){
			return $query->result();
		}else{
			return false;
		}
	}
	
	
	//
	public function getDistritos($codigoCanton){
	    $query = $this->db->get_where('distrito',array('codigo_canton'=>$codigoCanton));
		if ($query->num_rows() > 0){
			return $query->result();
		}else{
			return false;
		}
	}
	
	
	public function addParticipante($datosP){
	    
	    // eliminar participante en pendientes
		$where = array(
			'user_id' => $datosP->user_id
		);
		$this->db->delete('mensajesIncompletosParticipantesPlan', $where);
		
		// insertar participante
	    $hoy=date('Y-m-d');
	    $fechaInicioPlan= $this->cambiarFormatoAMysql(trim($datosP->fechaInicioPlan));
	    $inicio=$this->calcularInicio($fechaInicioPlan,$hoy);
	    $datos=array(
	        'user_id'=>$datosP->user_id,
	        'canal'=>$datosP->canal,
	        'paginaFaceBook'=>property_exists($datosP, 'paginaFB')?$datosP->paginaFB:'No aplica',
	        'nombre'=>$datosP->nombre,
	        'apellido'=>$datosP->apellidos,
	        'edad'=>$datosP->edad,
	        'email'=>$datosP->email,
	        'sexo'=>$datosP->sexo,
	        'codigo_provincia'=>$datosP->codigoProvincia,
	        'codigo_canton'=>$datosP->codigoCanton,
	        'codigo_distrito'=>$datosP->codigoDistrito,
	        'tipoFumado'=>$datosP->tipoFumado,
	        'fumoAntesVapear'=>property_exists($datosP, 'fumoAntesVapear')?$datosP->fumoAntesVapear:'No aplica',
	        'porCuantosAniosFumo'=>property_exists($datosP, 'porCuantosAniosFumo')?$datosP->porCuantosAniosFumo:'No aplica',
	        'edadInicioFumado'=>property_exists($datosP, 'edadInicioFumado')?$datosP->edadInicioFumado:'No aplica', 
	        'aniosFumado'=>property_exists($datosP, 'aniosFumado')?$datosP->aniosFumado:'No aplica',
	        'cantidadCig'=>property_exists($datosP, 'cantidadCigarrillos')?$datosP->cantidadCigarrillos:'No aplica', 
	        'fechaRegistro'=>date('Y-m-d h:i:s', time()),
	        'fechaDeBaja'=>'',
	        'fechaInicioPlan'=>$fechaInicioPlan,
	        'fechaInicioSistema'=>$inicio['inicio'],
	        'diaQ'=>$inicio['diaQ'],
	        'intentos'=>1,
	        'estado'=>1
	    );
	    $this->db->insert('participante',$datos);
	    return $this->db->affected_rows();
	}
	
	
	
	function cambiarFormatoAMysql($fecha){
	    preg_match( '/([0-9]{1,2})\/([0-9]{1,2})\/([0-9]{2,4})/', $fecha, $mifecha);
	    $lafecha=$mifecha[3]."-".$mifecha[2]."-".$mifecha[1];
	    return $lafecha;
	}
	
	
	function cambiarFormatoAMysql2($fecha){
	    preg_match( '/([0-9]{1,2})\/([0-9]{1,2})\/([0-9]{2,4})/', $fecha, $mifecha);
	    $lafecha=$mifecha[3]."/".$mifecha[2]."/".$mifecha[1];
	    return $lafecha;
	}
	
	
	public function calcularDiferenciaFechas($fechaInicio,$hoy){
	    $query ="select TIMESTAMPDIFF(day,'".$hoy."','".$fechaInicio."') as diferencia";
	    $query = $this->db->query($query);
	    return $query->row()->diferencia;
	}
	
	function cambiaf_a_espanol($fecha){
    preg_match( '/([0-9]{2,4})-([0-9]{1,2})-([0-9]{1,2})/', $fecha, $mifecha);
    $lafecha=$mifecha[3]."/".$mifecha[2]."/".$mifecha[1];
     return $lafecha;
    }
	
	
	
	
	public function calcularInicio($fechaInicio,$hoy){
	    $query ="select TIMESTAMPDIFF(day,'".$hoy."','".$fechaInicio."') as diferencia";
	    $query = $this->db->query($query);
	    $diferencia=$query->row()->diferencia;
	    if($diferencia>17){
	        $diferencia=17;
	    }else{
	        $diferencia-=1;
	    }
	    $query ="SELECT date_add('".$fechaInicio."', INTERVAL -".$diferencia." DAY) as inicio";
	    $query = $this->db->query($query);
	    return array('inicio'=> $query->row()->inicio, 'diaQ'=>'Q'.$diferencia);
	}
	

	
	/*------------------------------------------------- Funcion que obtiene todos los participantes temporalmente suspendidos.-----------------------------------------------------*/
	
	public function getPartiTempSusp(){
	     $this->db->where('idEstado',5);
	    $query = $this->db->get('participante');
		return ($query->num_rows()>0?$query->result():false);
	}
	
	
	/*------------------------------------------------- Funcion que recuperar los mensajes del Q o los d��as -----------------------------------------------------*/
	
	public function getMsgInicio($dia){
	    $this->db->where('dia',$dia);
	    $query = $this->db->get('mensajesDia');
		return ($query->num_rows()>0?$query->row():false);
	}
	/*------------------------------------------------- function para recuperar todos los mensajes correspondientes a ese d��a --------------------------------------*/
	
	public function getMsgDay($dia){
	    $this->db->where('dia',$dia);
	    $query = $this->db->get('mensajesDia');
		return ($query->num_rows()>0?$query->result():false);
	}
	
	
	
	/*------------------------------------------------- Funcion para cambiar el d��a en el que se encuentra -----------------------------------------------------*/
	public function cambiarDia($user_id,$fecha,$dia){
	    $diaAnterior=$dia;
	    $cambioFecha=date("Y-m-d",strtotime($fecha."+ 1 days"));
	    if(is_numeric ($dia)){
	        $dia+=1;
	        if($dia==97){
	            $cambioFecha=date("Y-m-d",strtotime($fecha."+ 6 month")); 
	        }else if($dia>97){
	            $cambioFecha=date("Y-m-d",strtotime($fecha."+ 3 month"));
	        }
	        
	    }else if($dia!='Q0'){
	        $dia=substr( $dia , 1, Strlen($dia));
	        $dia-=1;
	        $dia='Q'.$dia;
	    }else{
	        $dia=1;
	    }
	    $data=array('fechaInicioSistema'=>$cambioFecha,"diaQ"=>$dia);
	    $this->db->where("user_id",$user_id);
	    $this->db->update("participante",$data);
	}
	
	public function changeDiaCompleto($user_id){
	    $data=array('diaCompleto'=>'Y');
	    $this->db->where("user_id",$user_id);
	    $this->db->update("participante",$data);
	
	}
	
	
	/*----------------------------------------------------------------- funcion para obtener los datos de un participante----------------------------------*/
	public function getParticipante($user_id){
	    $this->db->where('user_id',$user_id);
	    $query = $this->db->get('participante');
		return ($query->num_rows()>0?$query->row():false);
	}
	
	/*---------------------------------------------------- Esta funcion permite agregar una sugerencia -----------------------------------------------------------*/
	
	
	public function addSugerencia($datos){
	    $fecha=date('Y-m-d h:i:s',time());
	    $this->db->insert('sugerencia', array('user_id'=>$datos->user_id,'sugerencia'=>$datos->sugerencia,'fechaRegistro'=>$fecha));
	}
	
	public function addModule($idParticipante,$diaPlan,$fecha,$envio){
	    $this->db->insert('module',array('idParticipante'=>$idParticipante,'diaPlan'=>$diaPlan,'estado'=>'Iniciado','fecha'=>$fecha,'envio'=>$envio));
	}
	
	public function updateModule($idParticipante,$diaPlan){
	    $data = array(
               'estado' =>'Terminado'
            );
	    $array = array('idParticipante' => $idParticipante, 'diaPlan' => $diaPlan,'fecha'=>date('Y-m-d'));
	    $this->db->where($array);
	    $this->db->update('module',$data);
	}
	
	public function updateParticipante($datosP,$intentos){
	    $hoy=date('Y-m-d');
	    $fechaInicioPlan= $this->cambiarFormatoAMysql(trim($datosP->fechaInicioPlan));
	    $inicio=$this->calcularInicio($fechaInicioPlan,$hoy);
	     $this->db->where('user_id',$datosP->from->id);
	    $this->db->update('participante',array('fechaInicioPlan'=>$fechaInicioPlan,'idEstado'=>1,'fechaInicioSistema'=>$inicio['inicio'],'diaQ'=>$inicio['diaQ'],'intentos'=>$intentos+1));
	}
	

	
	
		/*---------------------------------------------------------------------- Function para pasar el estado de un participante a suspendido -----------------------------------------------------*/
	
	public function salirPrograma($user_id)
	{
	     $hoy=date('Y-m-d');
	    $this->db->where('user_id',$user_id);
	    $this->db->update('participante',array('fechaDeBaja'=>$hoy));
	}
	
	
	
	/*---------------------------------------------------------------------------- Obtenemos número de intentos de un participante -------------------------------------------------------------------------*/
	
	function getNumIntentos($user_id)
    {
       $query=$this->db->get_where('participante',array('user_id'=>$user_id));
       return $query->row()->intentos;
    }
    
    /*------------------------------------------------------------------------------ cambiamos la fecha de inicio del plan del participante -------------------------------------------------*/
    
    public function updateFechaInicioPlan($fechaNueva,$user_id){
        $numIntentos=$this->getNumIntentos($user_id)+1;
	    $this->db->where('user_id',$user_id);
	    $this->db->update('participante',array('fechaInicioPlan'=>$fechaNueva,'estado'=>1,'fechaInicioSistema'=>$fechaNueva,'diaQ'=>'Q0','intentos'=>$numIntentos));
	    return $this->db->affected_rows();
	}
	
	/*------------------------------------------------------------------------------ cambiamos la fecha de inicio del plan del participante -------------------------------------------------*/
    
    public function reinicioPlan($fechaNueva,$intentos,$user_id){
	    $hoy=date('Y-m-d');
	    $fechaInicioPlan=trim($fechaNueva);
	    $inicio=$this->calcularInicio($fechaInicioPlan,$hoy);
	     $this->db->where('user_id',$user_id);
	    $this->db->update('participante',array('fechaInicioPlan'=>$fechaInicioPlan,'idEstado'=>1,'fechaInicioSistema'=>$inicio['inicio'],'diaQ'=>'Q17','intentos'=>$intentos+1,'diaAnterior'=>'','fechaAnterior'=>'','diaCompleto'=>''));
	}
    
    
    
	/*------------------------------------------------------------------------Funcion para cambiar los mensajes que son de suspesi��n temporal ------------------------------------------------*/
	
    /*------------------------------------------------- Funcion para cambiar el d��a en el que se encuentra -----------------------------------------------------*/
	public function changeDaySusp($fecha,$dia,$user_id){
	    $diaAnterior=$dia;
	    $cambioFecha=date("Y-m-d",strtotime($fecha."+ 1 days"));
	    $dia=substr( $dia , 1, Strlen($dia))+1;/* Extraemos la letra y le sumamos uno*/
	    $dia='R'.$dia;
	    $data=array('fechaInicioSistema'=>$cambioFecha,"diaQ"=>$dia);
	    $this->db->where("user_id",$user_id);
	    $this->db->update("participante",$data);
	}
	

	
	/*---------------------- ------------------------------------------------------------             Implementaci�n bot framework           --------------------------------------------------*/
	

	
		
	/*------------------------------------------------- Funcion que recupera todos los participantes activos-----------------------------------------------------*/
	
	public function getParticipantesPlan($canal,$estado){
	    $hoy=date('Y-m-d');
        $this->db->select('p.user_id,p.paginaFaceBook,p.nombre,p.diaQ,p.estado,p.fechaInicioSistema,p.canal,m.opciones,m.mensaje');
        $this->db->from('participante p');
        $this->db->join('mensajesDia m', "p.diaQ=m.dia and p.estado='{$estado}' and canal='{$canal}' and p.fechaInicioSistema='{$hoy}' group by p.user_id");
	    $query = $this->db->get();
		return ($query->num_rows()>0?$query->result():false);
	    
	}
	
	
	public function getMsgEnvioPartipante($user_id){
        $this->db->select('*');
        $this->db->from('mensajesEnviadosParticipantePlan');
        $this->db->where("idMensajeEnviado = (
                                            select MAX(idMensajeEnviado) 
                                            from mensajesEnviadosParticipantePlan 
                                            where user_id='{$user_id}'
                                            )");
	    $query = $this->db->get();
		return ($query->num_rows()>0?$query->result():false);
	}
	
	/*---------------------------------------------------------------------- Function para cambiar el estado de un participante -----------------------------------------------------*/
	
	public function changeState($user_id,$estado)
	{

	    $this->db->where('user_id',$user_id);
	    $this->db->update('participante',array('estado'=>$estado));

	      
	    return $this->db->affected_rows();
	}
	
	public function addMensajeEnviado($user_id,$diaPlan){
	    $datos=array(
	                'idMensajeEnviado'=>null,
	                'user_id'=>$user_id,
	                'diaPlan'=>$diaPlan,
	                'fecha'=>date('Y-m-d h:i:s',time()),
	                'estadoEnvio'=>1
	    );
	    $this->db->insert('mensajesEnviadosParticipantePlan',$datos);
	}
	
	/*---------------------------------------------------------------------- comprueba si el participante ya est� registrado -----------------------------------------------------*/
	
	function verificarRegistroUser($user_id){
	    $this->db->where('user_id',$user_id);
	    $query = $this->db->get('participante');
	    return $query->num_rows() > 0?$query->result():false;
	}
	
		/*---------------------------------------------------------------------- comprueba si el participante ya est� registrado -----------------------------------------------------*/
	
	function comprobrarDiaActivo($user_id){
	     $hoy=date('Y-m-d');
	    $this->db->select('*');
        $this->db->from('mensajesEnviadosParticipantePlan');
        $this->db->where("idMensajeEnviado = (
                                            select MAX(idMensajeEnviado) 
                                            from mensajesEnviadosParticipantePlan 
                                            where user_id='{$user_id}' and fecha='{$hoy}' and estadoEnvio=1
                                            )");
	    $query = $this->db->get();
		return ($query->num_rows()>0?$query->result():false);
	}
	
	/*---------------------------------------------------------------------- comprueba si el participante ya est� registrado -----------------------------------------------------*/
	
	function finalizarDia($mensaje){
	    if($mensaje->diaPlan=='90'){
	        $this->changeState($mensaje->user_id,4);// Sí el usuario llegó al día 90 y sí respondió pasar el usuario a un estado de finalizado.
	    }else if($mensaje->diaPlan=="R7" && property_exists($mensaje, 'cancelarPlan')){
	        $this->changeState($mensaje->user_id,3); // Sí la participante llegó al R7 y no cambió la fecha se pasa el participante a un estado de cancelado.
	    }
	    $this->db->where('idMensajeEnviado',$mensaje->idMensajeEnviado);
	    $result=$this->db->update('mensajesEnviadosParticipantePlan',array('estadoEnvio'=>2));
	    return $this->db->affected_rows();
	}
	
	function cambiarDiaParticipante($user_id,$dia){
	    $hoy=date('Y-m-d');
	    $this->db->where('user_id',$user_id);
	    $this->db->update('participante',array('fechaInicioSistema'=>$hoy,'diaQ'=>$dia));
	    return $this->db->affected_rows();
	}
	
	function verificarRepParticipante($dia){
	    $this->db->where('dia',$dia);
	    $query = $this->db->get('mensajesDia');
	    return $query->row()->opciones;
	}
	
	/*-----------------------------------------------------------------------Cambiamos el día para un participante inactivo ---------------------------------------------------*/
	
	//----------------------pruebas ------------------------------------------------------------------
	
	
		public function CambiarDiaNew($user_id,$fecha,$texto){
	if($texto === "si" || $texto === "no"){
		$this->db->select_max('idhistorialMensajesRetomarPlan');
		$this->db->where("id_user",$user_id);
        $query = $this->db->get('historialMensajesRetomarPlan');
        $id = $query->row()->idhistorialMensajesRetomarPlan;

		$data=array("respuesta"=>$texto);
	    $this->db->where("idhistorialMensajesRetomarPlan",$id);
	    $this->db->update("historialMensajesRetomarPlan",$data);
	    $actualizo = $this->db->affected_rows();
	    
	    if($actualizo>0 && ($texto === "no")){
		       return false;
		   }else{
		       if($actualizo>0 && $texto === "si"){
        		$data=array('fechaInicioSistema'=>$fecha,'estado'=>1);
        	    $this->db->where("user_id",$user_id);
        	    $this->db->update("participante",$data);
        	    return $this->db->affected_rows()>0 && $this->reactivarPlan($user_id)>0?true:false;
		       }
		   }
		   
		   }else{
		       	$data=array('fechaInicioSistema'=>$fecha,'estado'=>1);
        	    $this->db->where("user_id",$user_id);
        	    $this->db->update("participante",$data);
        	    return $this->db->affected_rows()>0 && $this->reactivarPlan($user_id)>0?true:false;
		   }

	}
	
		//----------------------pruebas ------------------------------------------------------------------
	//ya no se usa
	public function changeDayInactivo($user_id,$fecha){
	    $data=array('fechaInicioSistema'=>$fecha,'estado'=>1);
	    $this->db->where("user_id",$user_id);
	    $this->db->update("participante",$data);
	    return $this->db->affected_rows()>0 && $this->reactivarPlan($user_id)>0?true:false;
	}
	
	/*-----------------------------------------------------------------------------*/
	public function reactivarPlan($user_id){
	    $max=$this->obtenerMax($user_id);
	    $data=array("estadoEnvio"=>3);
	    $this->db->where("user_id",$user_id);
	    $this->db->where('idMensajeEnviado',$max);
	    $this->db->update("mensajesEnviadosParticipantePlan",$data);
	    return $this->db->affected_rows();
	}
	
	/*----------------------------------------------------------------------- obtenemos el último mensaje que se le envió al participante ---------------------------------------------------*/
	
	public function obtenerMax($user_id){
	    $this->db->select_max("idMensajeEnviado");
	    $this->db->where("user_id",$user_id);
	    $this->db->where("estadoEnvio",1);
	    $query = $this->db->get("mensajesEnviadosParticipantePlan");
	    return $query->row()->idMensajeEnviado;
	}
	
	
	/*----------------------------------------------------------------------- obtenemos el último mensaje que se le envió al participante ---------------------------------------------------*/
	
	public function obtenerDiaParticipante($user_id){
	    $hoy=date('Y-m-d');
	    $this->db->select('*');
        $this->db->from('mensajesEnviadosParticipantePlan as mE');
        $this->db->join('mensajesDia m', "mE.diaPlan=m.dia");
        $this->db->where("idMensajeEnviado = (
                                            select MAX(idMensajeEnviado) 
                                            from mensajesEnviadosParticipantePlan 
                                            where user_id='{$user_id}' and fecha='{$hoy}' and estadoEnvio=1
                                            )");
	    $query = $this->db->get();
	    return ($query->num_rows()>0?$query->row():false);
	}
	
	/*---------------------------------------------------- Cambiar la fecha para los mensajes R --------------------------------------------------------------------------------------*/
	
	function changeRs($user_id){
	    $hoy=date("Y-m-d");
	    $cambioFecha=date("Y-m-d",strtotime($hoy."+ 1 days"));
	    $this->db->where('user_id',$user_id);
	    $this->db->update('participante',array('fechaInicioSistema'=>$cambioFecha,'diaQ'=>'R1'));
	    return $this->db->affected_rows();
	}
	
    /*----------------------------------------------------------------------abandonar plan -----------------------------------------------------*/
	
	public function abandonarPlan($user_id,$estado)
	{
	    $hoy=date("Y-m-d");
	    $this->db->where('user_id',$user_id);
	    $this->db->update('participante',array('estado'=>$estado,"fechaDeBaja"=>$hoy));
	    return $this->db->affected_rows();
	}
	
	/*----------------------------------------------------------------------actualizar incompletos -----------------------------------------------------*/
	
	public function updateIncompletos($datosP)
	{
		// obtener código de usuario
		$where = array(
			'user_id' => $datosP->user_id
		);
		$this->db->select('user_id');
		$query = $this->db->get_where('mensajesIncompletosParticipantesPlan', $where);
		$hoy=date('Y-m-d');

		if ($query->num_rows() == 0) {
			$datos=array(
				'user_id'=>$datosP->user_id,
				'canal'=>$datosP->canal,
				'fecha_inicio'=>$hoy,
				'fecha_actualizacion'=>$hoy,
				'ultimo_mensaje'=>$datosP->mensaje
			);
			$this->db->insert('mensajesIncompletosParticipantesPlan',$datos);
			return $this->db->affected_rows();
		}else{
			$datos=array(
				'fecha_actualizacion'=>$hoy,
				'ultimo_mensaje'=>$datosP->mensaje
			);
			$this->db->where('user_id', $datosP->user_id);
			$this->db->update('mensajesIncompletosParticipantesPlan',$datos);
			return $this->db->affected_rows();
		}
	}
	
// 	/*----------------------------------------------------------------------lista de usuarios inactivos -----------------------------------------------------*/
	
	public function listInactivos()
    	{
             $query = "h.idhistorialMensajesRetomarPlan = (select idhistorialMensajesRetomarPlan from historialMensajesRetomarPlan h
                        where h.id_user = p.user_id and h.idMensajeEnviado = 1 ORDER by h.idhistorialMensajesRetomarPlan desc limit 1)  
                        and ( h.respuesta <> 'no' and h.respuesta <> '2' and (select COUNT(id_user) from historialMensajesRetomarPlan h
                        where h.id_user = p.user_id and h.idMensajeEnviado = 1 and respuesta is null)  < 2) and p.estado = 2" ;
                        
             $this->db->select('p.user_id,p.nombre,m.mensaje,m.opciones,m.idMensaje,h.idhistorialMensajesRetomarPlan');
             $this->db->from('participante p');
             $this->db->join('historialMensajesRetomarPlan h', 'p.user_id = h.id_user');
             $this->db->join('mensajesRetomarPlan m', 'm.idMensaje = "1"');
             $this->db->where($query,null,false);
             
            $Result = $this->db->get();
            return $this->listInactivosPrimerMsj($Result->result());
    	}
	
public function listInactivosPrimerMsj($listaInactivos)
    	{
             $query = "user_id NOT IN (SELECT id_user FROM historialMensajesRetomarPlan) AND estado = '2'";
             $this->db->select('user_id,nombre,m.mensaje,m.opciones,m.idMensaje');
             $this->db->from('participante');
             $this->db->join('mensajesRetomarPlan m', 'm.idMensaje = "1"');
             $this->db->where($query,null,false);
            
            $Result = $this->db->get();
            $listaCompletaInactivos = array_merge($listaInactivos, $Result->result());
            return $listaCompletaInactivos;
    	}
	/*----------------------------------------------------------------------lista de UsuariosNoInscritos -----------------------------------------------------*/
		public function listNoInscritos()
    	{
             $query = "h.idhistorialMensajesRetomarPlan = (select idhistorialMensajesRetomarPlan from historialMensajesRetomarPlan h
                        where h.id_user = mi.user_id and h.idMensajeEnviado = 2  ORDER by h.idhistorialMensajesRetomarPlan desc limit 1)  
                        and ( h.respuesta <> 'no' and h.respuesta <> '2' and (select COUNT(id_user) from historialMensajesRetomarPlan h
                        where h.id_user = mi.user_id and h.idMensajeEnviado = 2 and respuesta is null)  < 2 )";
                        
             $this->db->select('mi.user_id,m.mensaje,m.opciones,m.idMensaje,h.idhistorialMensajesRetomarPlan');
             $this->db->from('mensajesIncompletosParticipantesPlan mi');
             $this->db->join('historialMensajesRetomarPlan h', 'mi.user_id = h.id_user');
             $this->db->join('mensajesRetomarPlan m', 'm.idMensaje = "2"');
             $this->db->where($query,null,false);
             
            $Result = $this->db->get();

            return $this->listNoInscritosPrimerMsj($Result->result());
    	}

	public function listNoInscritosPrimerMsj($listaNoInscritos)
	{
	$query = "user_id NOT IN (SELECT id_user FROM historialMensajesRetomarPlan) AND canal = '2' AND ultimo_mensaje != 'Ingresá una fecha para iniciar con el plan.'
	AND fecha_actualizacion < CURDATE()";
             $this->db->select('user_id,m.mensaje,m.opciones,m.idMensaje');
             $this->db->from('mensajesIncompletosParticipantesPlan');
             $this->db->join('mensajesRetomarPlan m', 'm.idMensaje = "2"');
             $this->db->where($query,null,false);
             $Result = $this->db->get();
    $listaCompletaNoInscritos = array_merge($listaNoInscritos, $Result->result());

    return $listaCompletaNoInscritos;
		
	}
	
	/*----------------------------------------------------------------------lista de UsuariosNoFechaCese -----------------------------------------------------*/
	
	public function listNoFechaCese()
	{
        $query = "h.idhistorialMensajesRetomarPlan = (select idhistorialMensajesRetomarPlan from historialMensajesRetomarPlan h
                        where h.id_user = mi.user_id and h.idMensajeEnviado = 3  ORDER by h.idhistorialMensajesRetomarPlan desc limit 1)  
                        and ( h.respuesta <> 'no' and h.respuesta <> '2' and (select COUNT(id_user) from historialMensajesRetomarPlan h
                        where h.id_user = mi.user_id and h.idMensajeEnviado = 3 and respuesta is null)  < 2 )";
                        
             $this->db->select('mi.user_id,m.mensaje,m.opciones,m.idMensaje,h.idhistorialMensajesRetomarPlan');
             $this->db->from('mensajesIncompletosParticipantesPlan mi');
             $this->db->join('historialMensajesRetomarPlan h', 'mi.user_id = h.id_user');
             $this->db->join('mensajesRetomarPlan m', 'm.idMensaje = "3"');
             $this->db->where($query,null,false);
             
            $Result = $this->db->get();
            return $this->listNoFechaCesePrimerMsj($Result->result());
    	}

	public function listNoFechaCesePrimerMsj($listaNoInscritos)
	{
    	$query = "user_id NOT IN (SELECT id_user FROM historialMensajesRetomarPlan) AND canal = '2' AND ultimo_mensaje = 'Ingresá una fecha para iniciar con el plan.'
    	          AND fecha_actualizacion < CURDATE()";
                 $this->db->select('user_id,m.mensaje,m.opciones,m.idMensaje');
                 $this->db->from('mensajesIncompletosParticipantesPlan');
                 $this->db->join('mensajesRetomarPlan m', 'm.idMensaje = "3"');
                 $this->db->where($query,null,false);
                 $Result = $this->db->get();
        $listaCompletaNoInscritos = array_merge($listaNoInscritos, $Result->result());
        return $listaCompletaNoInscritos;
	}
	/*----------------------------------------------------------------------insertar de Historial RetomarPlan -----------------------------------------------------*/
public function insertarHistorialMensajesRetomarPlan($datosH)
	{
		$datos=array(
				'idMensajeEnviado'=>$datosH->idMensaje,
				'id_user'=>$datosH->user_id
			);
			$this->db->insert('historialMensajesRetomarPlan',$datos);
			return $this->db->affected_rows();
	}
		/*----------------------------------------------------------------------verificar si se le envio el mensaje de terminar de llenar el form -----------------------------------------------------*/
public function verificarUsuario($dato)
	{
		$query = "id_user = '{$dato}' AND respuesta is null 
		order by idhistorialMensajesRetomarPlan desc
		limit 1";
             $this->db->from('historialMensajesRetomarPlan');
             $this->db->where($query,null,false);
            
            $Result = $this->db->get();
        return $Result->result();
	}
	
public function insertarRespuestaLlenarForm($datosP)
	{
			$datos=array(
				'respuesta'=>$datosP->mensaje
			);
	     	$query = "id_user = '{$datosP->user_id}'
	        order by idhistorialMensajesRetomarPlan desc
		    limit 1";
			$this->db->where($query,null,false);
			$this->db->update('historialMensajesRetomarPlan',$datos);
			return $this->db->affected_rows();
	}
	
		/*----------------------------------------------------------------------insertar respuestas del ultimo dia(90) -----------------------------------------------------*/
	
	public function guardarRespuestasUltimoDia($datosP)
	{
			$datos=array(
				$datosP->columna=>$datosP->mensaje
			);
	     	$query = "user_id = '{$datosP->user_id}'";
			$this->db->where($query,null,false);
			$this->db->update('participante',$datos);
			return $this->db->affected_rows();
	}
		/*----------------------------------------------------------------------insertar mensajes enviados de seguimiento -----------------------------------------------------*/
	public function guardarMensajeEnviadoSeguimiento($datosP)
	{
	    $hoy=date('Y-m-d');
			$datos=array(
				'user_id'=>$datosP->user_id,
				'seguimiento_id'=>$datosP->dia,
				'fecha'=>$hoy,
				'estadoEnvio_id'=>1
			);
	     	$query = "user_id = '{$datosP->user_id}'";
			$this->db->where($query,null,false);
			$this->db->insert('mensajesSeguimientoEnviados',$datos);
			return $this->db->affected_rows();
	}
	/*----------------------------------------------------------------------insertar respuestas de seguimiento -----------------------------------------------------*/
	public function guardarRespuestasSeguimiento($datosP)
	{
			$datos=array(
				'respuesta'=>$datosP->mensajeResp,
				'estadoEnvio_id'=> 2
			);
	     	$query = "user_id = '{$datosP->user_id}' AND seguimiento_id = 'R1'";
			$this->db->where($query,null,false);
			$this->db->update('mensajesSeguimientoEnviados',$datos);
			return $this->db->affected_rows();
	}
	
		public function guardarRespuestasSeguimientoPlantillas($datosP)
	{
			$datos=array(
				'respuesta'=>$datosP->mensajeResp,
				'estadoEnvio_id'=> 2
			);
	     	$query = "user_id = '{$datosP->user_id}' AND seguimiento_id = '{$datosP->seguimiento_id}'";
			$this->db->where($query,null,false);
			$this->db->update('mensajesSeguimientoEnviados',$datos);
			
			$datos=array(
				'diaQ'=>$datosP->seguimiento_id,
				'estado'=>7
			);
	     	$query = "user_id = '{$datosP->user_id}'";
			$this->db->where($query,null,false);
			$this->db->update('participante',$datos);
			
			
			return $this->db->affected_rows();
	}
		/*----------------------------------------------------------------------lista de participantes de Seguimiento -----------------------------------------------------*/
		
	public function listSeguimiento()
    	{ 

     $query = "tiempoEnvio > 0 AND nivel = 0";
             $this->db->select('dia,nivel,tiempoEnvio');
             $this->db->from('mensajesSeguimiento');
             $this->db->where($query,null,false);
             $listaMeses = $this->db->get();
             
              
     $query = "tiempoEnvio > 0 AND nivel <> 0";
             $this->db->select('dia,nivel,tiempoEnvio,nombrePlantilla');
             $this->db->from('mensajesSeguimiento');
             $this->db->where($query,null,false);
             $listaDias = $this->db->get();

            return $this->listSeguimientoMeses($listaMeses,$listaDias);
    	}
		
		
		public function listSeguimientoMeses($listaMeses,$listaDias)
    	{
    	    $Result = [];
    	    foreach ($listaMeses->result() as &$valor) {
             $query = "p.canal = 2 
                        AND  (p.diaQ = 91 OR p.diaQ = 'S10' OR p.diaQ = 'S12' OR p.diaQ = 'S13')
                        AND me.diaPlan = 90
                        AND (TIMESTAMPDIFF(MONTH, me.fecha, NOW())) = '{$valor->tiempoEnvio}' 
                        AND  '{$valor->dia}'  Not IN 
                        (SELECT seguimiento_id FROM mensajesSeguimientoEnviados WHERE seguimiento_id = '{$valor->dia}' and user_id = me.user_id )
                        GROUP BY me.user_id";
                        
             $this->db->select('p.user_id, ms.nombrePlantilla,ms.dia');
             $this->db->from('participante p');
             $this->db->join('mensajesEnviadosParticipantePlan me', 'me.user_id = p.user_id ');
             $this->db->join('mensajesSeguimiento ms', "ms.dia = '{$valor->dia}'");
             $this->db->where($query,null,false);
             $lista = $this->db->get();
            $Result = array_merge($Result, $lista->result());
        }
            return $this->listSeguimientoDias($Result,$listaDias);
    	}

	public function listSeguimientoDias($listaSeguimiento,$listaDias )
	{
	      $query = "(p.estado = 4 OR p.estado = 7)
                    AND  mse.seguimiento_id = 'S10'or mse.seguimiento_id = 'S1'
                    AND mse.id IN 
                    (SELECT max(id) FROM mensajesSeguimientoEnviados WHERE seguimiento_id = 'S10' OR seguimiento_id = 'S1'  GROUP BY mse.user_id)";
             $this->db->select('mse.id,p.user_id, (TIMESTAMPDIFF(DAY, mse.fecha, NOW())) as dias , mse.seguimiento_id, mse.respuesta');
             $this->db->from('participante p');
             $this->db->join('mensajesSeguimientoEnviados mse', "mse.user_id = p.user_id");
             $this->db->where($query,null,false);
             $lista = $this->db->get();
             
             $Result =[];
             $newParticipante = new stdClass();
             
    	    foreach($listaDias->result() as &$valor) {
    	        foreach($lista->result() as &$data) {
    	            if($data->dias === $valor->tiempoEnvio) {

                    $newParticipante->user_id = $data->user_id;
                     $newParticipante->dia = $valor->dia;
                    $newParticipante->nombrePlantilla = $valor->nombrePlantilla;
                    
                    array_push($Result,$newParticipante);
                    }
    	        }
    	    }

    $listaCompletaSeguimiento = array_merge($listaSeguimiento, $Result);

    return $listaCompletaSeguimiento;
		
	}
	//metodo para las personas inactivas debido al cambio de vonage
		public function listReconexion()
	{
 $query = "p.canal = 2 AND  p.estado = 2 AND fechaInicioSistema > '2023-06-01' AND fechaInicioSistema != '2024-01-10'";
             $this->db->select('p.user_id');
             $this->db->from('participante p');
             $this->db->where($query,null,false);
             $lista = $this->db->get();
             
             $Result =[];
             
    	        foreach($lista->result() as &$info) {
                    $participante = new stdClass();
                    $participante->user_id = $info->user_id;
                    $participante->nombrePlantilla = 'reconexion_ms_usuarios';
                   
                    array_push($Result,$participante);
           
    	        }
    	        array_splice($Result, 0, 40);

    return $Result;
		
	}
	
	//Obtener el dia de seguimiento para mostrar el dialogo en el bot
	public	function comprobrarDiaSeguimiento($user_id){
        $query = "mse.user_id = '{$user_id}'
                  AND mse.seguimiento_id = 
                  (SELECT diaQ 
                  FROM participante 
                  WHERE user_id = '{$user_id}')";
                    
	    $this->db->select('p.diaQ, mse.respuesta, ms.opciones');
        $this->db->from('participante p');
        $this->db->join('mensajesSeguimientoEnviados mse', "mse.user_id = p.user_id");
        $this->db->join('mensajesSeguimiento ms', "ms.dia = p.diaQ");
        $this->db->where($query,null,false);
	    $query = $this->db->get();
		return ($query->num_rows()>0?$query->result():false);
	}
		
		public function actualizarEstadoEnvioAndDiaQ($datosP)
	{
	    	$datos=array(
				'diaQ'=>$datosP->siguiente
			);
	     	$query = "user_id = '{$datosP->user_id}'";
			$this->db->where($query,null,false);
			$this->db->update('participante',$datos);
	    
	    	$datos=array(
				'estadoEnvio_id'=> 5
			);
	     	$query = "user_id = '{$datosP->user_id}' AND seguimiento_id = '{$datosP->seguimiento_id}'";
			$this->db->where($query,null,false);
			$this->db->update('mensajesSeguimientoEnviados',$datos);
			
			return $this->db->affected_rows();
	}
} 