<?php
require_once __DIR__ . '/autoload.php'; // change path as needed


session_start();

$fb = new \Facebook\Facebook([
  'app_id' => '524482348148454',
  'app_secret' => '71558e260500da913db7b34443183837',
  'default_graph_version' => 'v2.10',
 // 'default_access_token' => 'ab8d2c6c8a03e69fc3a8737d7db402fc', // optional
]);


$helper = $fb->getRedirectLoginHelper();

if (isset($_GET['state'])) {
    $helper->getPersistentDataHandler()->set('state', $_GET['state']);
}


try {
  $accessToken = $helper->getAccessToken();
} catch(Facebook\Exceptions\FacebookResponseException $e) {
  // When Graph returns an error
  echo 'Graph returned an error: ' . $e->getMessage();
  exit;
} catch(Facebook\Exceptions\FacebookSDKException $e) {
  // When validation fails or other local issues
  echo 'Facebook SDK returned an error: ' . $e->getMessage();
  exit;
}

if (! isset($accessToken)) {
  if ($helper->getError()) {
    header('HTTP/1.0 401 Unauthorized');
    echo "Error: " . $helper->getError() . "\n";
    echo "Error Code: " . $helper->getErrorCode() . "\n";
    echo "Error Reason: " . $helper->getErrorReason() . "\n";
    echo "Error Description: " . $helper->getErrorDescription() . "\n";
  } else {
    header('HTTP/1.0 400 Bad Request');
    echo 'Bad request';
  }
  exit;
}

// Logged in
echo '<h3>Access Token</h3>';
var_dump($accessToken->getValue());

// The OAuth 2.0 client handler helps us manage access tokens
$oAuth2Client = $fb->getOAuth2Client();


var_dump($oAuth2Client);

// Get the access token metadata from /debug_token
$tokenMetadata = $oAuth2Client->debugToken($accessToken);
echo '<h3>Metadata</h3>';
var_dump($tokenMetadata);



//$tokenMetadata->getUserId() obtiene el id del usuario

// Validation (these will throw FacebookSDKException's when they fail)


$tokenMetadata->validateAppId('524482348148454');
// If you know the user ID this access token belongs to, you can validate it here
//$tokenMetadata->validateUserId('123');
$tokenMetadata->validateExpiration();

if (! $accessToken->isLongLived()) {
  // Exchanges a short-lived access token for a long-lived one
  try {
    $accessToken = $oAuth2Client->getLongLivedAccessToken($accessToken);
  } catch (Facebook\Exceptions\FacebookSDKException $e) {
    echo "<p>  Error getting long-lived access token: " . $e->getMessage() . "</p>\n\n";
    exit;
  }

  echo '<h3>Long-lived</h3>';
  var_dump($accessToken->getValue());
}

$_SESSION['fb_access_token'] = (string) $accessToken;



try {
  // Returns a `FacebookFacebookResponse` object
  $response = $fb->api(
    '/me',
    array (
      'fields' => 'birthday','email',"id",'name'
    ),    
    $_SESSION["fb_access_token"]
  );
} catch(FacebookExceptionsFacebookResponseException $e) {
  echo 'Graph returned an error: ' . $e->getMessage();
  exit;
} catch(FacebookExceptionsFacebookSDKException $e) {
  echo 'Facebook SDK returned an error: ' . $e->getMessage();
  exit;
}
$graphNode = $response->getGraphNode();

var_dump($graphNode);

// User is logged in with a long-lived access token.
// You can redirect them to a members-only page.
//header('Location: https://example.com/members.php');  


/*
curl -X POST -H "Content-Type: application/json" -d '{
  "recipient":{
    "id":"<PSID>"
  },
  "message":{
    "text":"hello, world!"
  }
}' "https://graph.facebook.com/v5.0/me/messages?access_token=<PAGE_ACCESS_TOKEN>*/

        /*
       $url = 'https://graph.facebook.com/v5.0/me/messages?access_token=EAAHdA5ANZAuYBAGSyIF7ZCP7bJT36KSBw1M8ZBmzImmWUXDEPGRN7qeJmk1RV90JFeDWKUQnkLD1e5qXZBG6Ibmq3ZBYYXNb9jt6K2Mkkq87cXopU114YB6vpB2ZCM5N87S2Vek1oXGrC8dwnBEpOzfZAZBabb5DDqdmhT8lbUoTDgZDZD';
        //Initiate cURL.
        $ch = curl_init($url);
        //The JSON data.
        $jsonData = '{
            "messaging_type": "MESSAGE_TAG",
            "recipient":{
                "id":"2429822770615403"  
            },
            "message":{
                "text":"ojalá esto funcionara"
            }
        }';
        
        
        //Encode the array into JSON.
        $jsonDataEncoded = $jsonData;
        //Tell cURL that we want to send a POST request.
        curl_setopt($ch, CURLOPT_POST, 1);
         
        //Attach our encoded JSON string to the POST fields.
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonDataEncoded);
        //Set the content type to application/json
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
        //curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/x-www-form-urlencoded'));
        //Execute the request
        $result = curl_exec($ch);*/
        
        
       // var_dump($result);
        


?>