<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH . '/libraries/REST_Controller.php';

class Auth extends REST_Controller{

    function __construct(){
        parent::__construct();
	    header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
	    header("Access-Control-Allow-Headers: Content-Type, Content-Length, Accept-Encoding, X-Auth-Token, auth-token, x-requested-with, X-PINGOTHER");
	    header("Access-Control-Max-Age: 1728000");
        if ($this->input->method(TRUE) == 'OPTIONS') die();
        $this->load->model('Api_model');
        $this->load->helper('jwt_helper');
        $this->Api_model->destroyUserSession();
	}
	
	public function login_post(){
		if (!$this->angularpostdata){
		    $this->response(false);
		}
		$user = $this->Api_model->validarUsuario($this->angularpostdata);
		if($user){
			$this->Api_model->insertarPushToken($user,$this->angularpostdata);
			$user->iat = time();
			$user->exp = time()+21600; //6 horas;
			$jwt = JWT::encode($user, $this->config->item('encryption_key'));
			$response = array('token' => $jwt);
			$status = 200;
		}else{
			$response = 'Usuario no válido';
			$status = 401;
		}
		$this->response($response,$status);
	}
}
?>