<?php

if ( ! defined('BASEPATH')) exit('No direct script access allowed');


class ApiEnvioMensajes extends CI_Controller {
	
	public function __construct(){
		parent::__construct();
        $this->load->model('Api_model');
        date_default_timezone_set('America/Costa_Rica');
	}
	/*---------------------------------------------------------------------funciones para el envio de mensajes por los canales de FB y WA-------------------------------------------------------------------------------------------------*/
    	
    public function enviarMsgFB(){
	    $this->getParticipantesEnvio(1,'enviarMensajeFB',1);
	}
	
	public function enviarMsgWA(){
	    $this->getParticipantesEnvio(2,'enviarMensajeWA',1);
	}
	
	public function enviarMsgFBRecaida(){
	    $this->getParticipantesEnvio(1,'enviarMensajeFB',5);
	}
	
	public function enviarMsgWARecaida(){
	    $this->getParticipantesEnvio(2,'enviarMensajeWA',5);
	}
	
	 public function enviarMsgWAReactivarPlanInactivos(){
	    $this->getParticipantesInactivosNoinscritos(2,'mensajePlantilla',2,'listInactivos','reactivar_plan_inactivos');
	}
	
	 public function enviarMsgWAReactivarPlanNoInscritos(){
	    $this->getParticipantesInactivosNoinscritos(2,'mensajePlantilla',2,'listNoInscritos','reactivar_plan_no_inscritos');
	}
	public function enviarMsgWAReactivarPlanNoFechaCese(){
	    $this->getParticipantesInactivosNoinscritos(2,'mensajePlantilla',2,'listNoFechaCese','reactivar_plan_fecha_cese');
	}
	
	public function enviarMsgWASeguimiento(){
	    $this->getParticipantesSeguimiento(2,'mensajePlantilla','listSeguimiento');
	}
	
	public function cambiarFecha(){
	    $data=array('fechaInicioSistema'=>'2024-01-10','estado' => 1);
	    $this->db->where("canal", 2);
	    $this->db->update("participante",$data);
	    $dat=array('estadoEnvio'=> 2);
	    $this->db->update("mensajesEnviadosParticipantePlan",$dat);
	}
	
	
	public function enviarMsgWAReconexionNuevoNumero(){
	    $this->getParticipantesReconexion(2,'mensajePlantilla','listReconexion');
	}
	/*----------------------------------------------------------- Esta función es un template para el envio de mensajes en Facebook  \u000A salto de línea en los mensajes fb--------------------------------------------------------------------------------------------------*/
	
	public function templateMsg($idUser,$msg,$repRapida,$token)
	{
	    $url = 'https://graph.facebook.com/v5.0/me/messages?access_token='.$token;
        $ch =curl_init($url);
        $jsonData =json_encode( array(
                                    "tag" =>"CONFIRMED_EVENT_UPDATE",
                                    "messaging_type"=>"MESSAGE_TAG",
                                    "notification_type"=>"REGULAR",
                                    "recipient"=>array("id"=>$idUser),
                                    "message"=>array("text"=>$msg,"quick_replies"=>$repRapida)
                                )
                            );
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER,true);
        return curl_exec($ch);
	}
	
	
	
	public function enviarMensajeFB($user_id,$nombre,$mensaje,$opciones,$paginaFB){
	    
	    $token='EAAY3meQCJTABANoMBHBlym2MLrAZAt3uqqJeTZC2RbjIyCkKwr0RJCHUb0EexFHQWPk0GVRDtSYFPGDQqJEJzjG2HbeVVyBmCeTBnILK3z2aLMfLmUZCQprZBfJNKP5qWEkJmcZBQWdXZCcAcGxbOeRKA5H4CZCbwtZCc3dI0ZBNGwLmdWQGKvtYBbkZCM4PLGQG4ZD';
	    if(trim($paginaFB) =="Dejalo ir"){
	        $token='EAAY3meQCJTABAALxRGLqVKmxRG2tQKVlbnNgzbUGG6GABQ6cLRdCGAxsSuxQZCkkRj3iZBf4R8xEiTKaVi45f2dzPGXNUnLYcOgzoZAX28jmIopeocYssjy03NzJCcr8rHIGWAuV7vEzgn59hhMSaeu7j6mx5Wlp8NBD2dDkVkzqV0qu93GvrlKza9NijYZD';
	    }
	    
	    try {
	        $mensaje=$this->sustituirNombre($mensaje,$nombre);
	        $opciones=json_decode($opciones);
	        $tamanioArray=sizeof($opciones);
	        $repRapida=array();
	        for ($i = 0; $i <$tamanioArray; $i++) {
	            $repRapida[$i]=array(
                                "content_type"=> "text",
                                "title"=>$opciones[$i],
                                "payload"=>$opciones[$i]
                             );
	        }
	        $envio=$this->templateMsg($user_id,$mensaje,$repRapida,$token);//enviamos el usario,el mensaje y la respuesta rápida.  
	        $envio=json_decode($envio);
	        
	        /*----------------------------------------- si el participante nos bloquea ---------------------------------------------*/
	        if(property_exists ($envio, 'error') and $envio->error->code==551 and $envio->error->error_subcode==1545041){
	            $this->Api_model->changeState($user_id,6);
	        }
	        return true;
	    } catch (Exception $e) {
	         return var_dump( "Excepción capturada: {$e->getMessage()}\n");
	    }
	}
	
	/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	---------------------------------------------------------------- Función para enviar los mensajes por el canal de whatsApp o FB----------------------------------------------------------------- 
	--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	*/
	
	public function getParticipantesEnvio($canal,$metodoEnvio,$estado){
	 
	    $this->Api_model->limpiarTablaSessions();
	    $participantes=$this->Api_model->getParticipantesPlan($canal,$estado);// buscamos por el canal 
	  
	  if(!$participantes){
	        $canal=$canal==1?"Facebook":"WhatsApp";
	        return var_dump("No hay participantes activos en {$canal} para el envio de mensajes, con el  𝗲𝘀𝘁𝗮𝗱𝗼 𝗱𝗲𝗹 𝗽𝗮𝗿𝘁𝗶𝗰𝗶𝗽𝗮𝗻𝘁𝗲: {$estado}");
	    }
    print_r($participantes);
	    foreach($participantes as $participante){

	            $estadoEnvioDiaAnterior=$this->Api_model->getMsgEnvioPartipante($participante->user_id);
	           
	            if($estadoEnvioDiaAnterior!=false && ($estadoEnvioDiaAnterior[0]->diaPlan=="90" || $estadoEnvioDiaAnterior[0]->diaPlan=="R7" ) && $estadoEnvioDiaAnterior[0]->estadoEnvio==1){//si al usuario no llegó al día 90 independientemente si contestó o no pasa a concluido
    	            $estado=$estadoEnvioDiaAnterior[0]->diaPlan=="R7"?3:4;
    	            $this->Api_model->changeState($participante->user_id,$estado);
    	        }else if($estadoEnvioDiaAnterior===false || $estadoEnvioDiaAnterior[0]->estadoEnvio==2 || $estadoEnvioDiaAnterior[0]->estadoEnvio==3){
    	 
    	            $resultEnvio=$this->{$metodoEnvio}( $participante->user_id,$participante->nombre,$participante->mensaje,$participante->opciones,$participante->diaQ);
    	           
    	            sleep(1);
    	            
    	            if($resultEnvio==200){
    	               
    	                $this->Api_model->cambiarDia($participante->user_id,$participante->fechaInicioSistema,$participante->diaQ);
    	               
    	                $this->Api_model->addMensajeEnviado($participante->user_id,$participante->diaQ);
    	            
    	            }else{
    	                var_dump("No se pudo enviar el mensaje al número de teléfono o id de fb {$participante->user_id}");
    	            }
    	        }else if($estadoEnvioDiaAnterior[0]->estadoEnvio==1){
	              $this->Api_model->changeState($participante->user_id,2); //como el usuario no respondió al mensaje anterior se debe pasar a inactivo
	            }
	          //sleep(1);
	    }
	    die();
	}

//  ---------------------------------------------------------------- Funciones para enviar los mensajes de ractivar el plan por el canal de whatsApp ----------------------------------------------------------------- 

	public function getParticipantesInactivosNoinscritos($canal,$metodoEnvio,$estado,$apiModelMetodo,$nomPlantilla){
	    $participantes=$this->Api_model->{$apiModelMetodo}();
	           
	    print_r($participantes);
	 
	   if(!$participantes){
	        $canal="WhatsApp";
	        return var_dump("No hay participantes {$apiModelMetodo} en {$canal} para el envio de mensajes, con el  𝗲𝘀𝘁𝗮𝗱𝗼 𝗱𝗲𝗹 𝗽𝗮𝗿𝘁𝗶𝗰𝗶𝗽𝗮𝗻𝘁𝗲: {$estado}");
	   }
	    foreach($participantes as $participante){
	        
	        	$participante->nombre= "Usuario";
     	            $resultEnvio=$this->{$metodoEnvio}( $participante->user_id,$nomPlantilla,$participante->nombre);
     	       if($resultEnvio==200){
    	         
     	                $this->Api_model->insertarHistorialMensajesRetomarPlan($participante);
     	       }else{
     	           var_dump("No se pudo enviar el mensaje al número de teléfono o id de fb {$participante->user_id}");
    	            }
    	        
	            sleep(10);
	    }
	    die();
	}

	
	public function mensajePlantilla($phoneNumber,$nomPlantilla,$nombreCliente){
	    try {

	        $datos = json_encode( array("phoneNumber" =>$phoneNumber,"plantilla"=>$nomPlantilla,"nombreCliente"=>$nombreCliente));
	        
	        $result=json_decode($this->consumirServicioWAEnvioPlantilla($datos));
	        if($result->status==500){
	            return var_dump("ocurrió un error al enviarle el mensaje al número {$phoneNumber}");
	        }
	        return $result->status;
	    } catch (Exception $e) {
	        return var_dump( "Excepción capturada: {$e->getMessage()}\n");
	    }
	}
	
	
	//  ---------------------------------------------------------------- Funciones para enviar los mensajes de seguimiento por el canal de whatsApp ----------------------------------------------------------------- 

	public function getParticipantesSeguimiento($canal,$metodoEnvio,$apiModelMetodo){ 
	    $participantes=$this->Api_model->{$apiModelMetodo}();
	           
	    print_r($participantes);
	   if(!$participantes){
	        $canal="WhatsApp";
	        return var_dump("No hay participantes {$apiModelMetodo} en {$canal} para el envio de mensajes de Seguimiento");
	   } 
	    foreach($participantes as $participante){
	        
	        	$participante->nombre= "Usuario";
     	            $resultEnvio=$this->{$metodoEnvio}( $participante->user_id,$participante->nombrePlantilla,$participante->nombre);
     	       if($resultEnvio==200){
    	         if($participante->dia !== "S1" && $participante->dia !== "S10" && $participante->dia !== "S12" && $participante->dia !== "S13"){
    	             $participante->estadoEnvio = 4;
    	         }else{
    	             $participante->estadoEnvio = 1;
    	         }
     	                $this->Api_model->guardarMensajeEnviadoSeguimiento($participante);
     	       }else{
     	           var_dump("No se pudo enviar el mensaje al número de teléfono o id de fb {$participante->user_id}");
    	            }
    	        
	            sleep(10);
	    }
	    die();
	}
	//  ---------------------------------------------------------------- Funciones para enviar los mensajes de reconexion para los usuarios que quedaron inactivos por el canal de whatsApp debido a cambio de vonage a meta----------------------------------------------------------------- 
	public function getParticipantesReconexion($canal,$metodoEnvio,$apiModelMetodo){ 
	    $participantes=$this->Api_model->{$apiModelMetodo}();
	           
	    print_r($participantes);
	    /*
	   if(!$participantes){
	        $canal="WhatsApp";
	        return var_dump("No hay participantes {$apiModelMetodo} en {$canal} para el envio de mensajes de reconexion");
	   } 
	    foreach($participantes as $participante){
	        
     	            $resultEnvio=$this->{$metodoEnvio}( $participante->user_id,$participante->nombrePlantilla,'');
     	       if($resultEnvio==200){
                    var_dump("mensaje enviado {$participante->user_id}");
     	       }else{
     	           var_dump("No se pudo enviar el mensaje al número de teléfono o id de fb {$participante->user_id}");
    	            }
    	        
	            sleep(10);
	    }*/
	    die();
	}
	
	public function consumirServicioWAEnvioPlantilla($datos){
	      echo ($datos);
	    $process = curl_init('https://2940p18vs5.execute-api.us-east-1.amazonaws.com/prod/envioPlantilla');
        curl_setopt($process, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
        curl_setopt($process, CURLOPT_TIMEOUT, 30);
        curl_setopt($process, CURLOPT_POST, 1);
        curl_setopt($process, CURLOPT_POSTFIELDS, $datos);
        curl_setopt($process, CURLOPT_RETURNTRANSFER, TRUE);
        $result = curl_exec($process);
        curl_close($process);
        return $result;
	}


	
	/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	---------------------------------------------------------------- Función para enviar los mensajes por el canal de whatsApp ----------------------------------------------------------------- 
	--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	*/

	
	public function enviarMensajeWA($phoneNumber,$nombre,$mensaje,$opciones,$diaQ){
	    try {
	         print_r("enviarMensajeWA");
	        print_r($diaQ);
	        if($diaQ === "Q0"){
	             print_r("Entro Q0");
	          $datos = json_encode( array("phoneNumber" =>$phoneNumber,"plantilla"=>"preparacion_q0","nombreCliente"=>$nombre));
	          $result=json_decode($this->consumirServicioWAEnvioPlantilla($datos));
	          print_r($result);
	        }else{
	            
	        $mensaje=$this->sustituirNombre($mensaje,$nombre);
	        $opciones=json_decode($opciones);
	        $tamanioArray=sizeof($opciones);
	        for ($i = 0; $i <$tamanioArray; $i++) {
	            if($i==$tamanioArray-1){
	                $mensaje.=($i+1).":{$opciones[$i]}";
	            }else{
	                $mensaje.=($i+1).":{$opciones[$i]}\n";
	            }
	        }
	        $datos = json_encode( array("phoneNumber" =>$phoneNumber,"mensaje"=>$mensaje));
	        $result=json_decode($this->consumirServicioWA($datos));
	        }
	        if($result->status==500){
	            return var_dump("ocurrió un error al enviarle el mensaje al número {$phoneNumber}");
	        }
	        return $result->status;
	    } catch (Exception $e) {
	        return var_dump( "Excepción capturada: {$e->getMessage()}\n");
	    }
	}
	
	
	public function consumirServicioWA($datos){
	    //$process = curl_init('https://apiwhatsappbot.azurewebsites.net/mandarMensaje');
	    //$process = curl_init('http://3.83.177.169:5000/mandarMensaje');
	    
	    $process = curl_init('https://2940p18vs5.execute-api.us-east-1.amazonaws.com/prod/mandarMensaje');
        curl_setopt($process, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
        curl_setopt($process, CURLOPT_TIMEOUT, 30);
        curl_setopt($process, CURLOPT_POST, 1);
        curl_setopt($process, CURLOPT_POSTFIELDS, $datos);
        curl_setopt($process, CURLOPT_RETURNTRANSFER, TRUE);
        $result = curl_exec($process);
        curl_close($process);
        return $result;
	}
	
	public function sustituirNombre($mensaje,$nombre){
	    if(preg_match('/(nombre)/i', $mensaje)){
            $mensaje=str_replace('(nombre)' ,$nombre,$mensaje);
        }
        return $mensaje;
	}
	

	/*------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	-----------------------------------  Mantenemos activo el server del core del bot ya que se encuentra en una capa gratuita y sino está activo se apaga--------------------------------------
	--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	*/
	
	public function activarServerAzure(){
	    //file_get_contents("https://apiwhatsappbot.azurewebsites.net/");
	    file_get_contents('https://corebotdejardefumar.azurewebsites.net/api/mantenerActivoServer');//core del bot de dejar de fumar
	    file_get_contents('https://webapppopularpensiones.azurewebsites.net/api/mantenerActivoServer');//mantener activo el bot del popular
	    return "Activo";
	}
    
    /*-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- 
    -------------------------------------------------------------------------- Esta es una función que se utiliza para enviar mensajes a un unico usuario en un día en especifico.
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
	
	// ejemplo: https://smmcr.net/clientes/administradorBot/cambiarDia/?dia=Q17&user_id=numero_telefono
	
	public function cambiarDia(){
	    try {
	        
	        $output=$this->Api_model->cambiarDiaParticipante($_GET['user_id'],$_GET['dia']);
	        if($output==0){
	             echo json_encode(["status"=>200,"error"=> "No hay nada que actualziar\n"] );
	             die();
	        }
	        if(isset($_GET['recaida'])){
	            $participantes=$this->Api_model->getParticipantesPlan(2,5);// buscamos por el canal de ws
	        }else{
	             $participantes=$this->Api_model->getParticipantesPlan(2,1);// buscamos por el canal de ws
	        }
	        
	    if(!$participantes){
	        return var_dump("<br>"."\nNo hay participantes activos en whatsApp para el envio de mensajes.",$participantes);
	    }
	    foreach($participantes as $participante){
	        if($participante->user_id==$_GET['user_id']){
	        $comprobarEstadoParticipante=$this->Api_model->getMsgEnvioPartipante($participante->user_id);
	        if($comprobarEstadoParticipante===false || $comprobarEstadoParticipante[0]->estadoEnvio==2 ){//si al usuario no se le han enviado mensaje o respondió el mensaje anterior
	              $resultEnvio=$this->enviarMensajeWA( $participante->user_id,$participante->nombre,$participante->mensaje,$participante->opciones, $participante->diaQ);
	              if($resultEnvio==200){
	                  //$this->Api_model->cambiarDia($participante->user_id,$participante->fechaInicioSistema,$participante->diaQ);
	                  $this->Api_model->addMensajeEnviado($participante->user_id,$participante->diaQ);
	              }else{
	                  var_dump("no se pudo enviar el mensaje al número de teléfono o id de fb {$participante->user_id}");
	              }
	          }else if($comprobarEstadoParticipante[0]->estadoEnvio==1){
	              $this->Api_model->changeState($participante->user_id,2);// como el usuario no respondió al mensaje anterior se debe pasar a inactivo
	          }
	          sleep(10);
	        }
	    }
	    echo   json_encode(["status"=>200,"options"=>$output]);
	    } catch (Exception $e) {
	        echo [status=>500,"error"=> "Excepción capturada:{$e->getMessage()}"] ;
	    }
        die();
	}

}

?>