<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require APPPATH . '/libraries/REST_Controller.php';

class Api extends REST_Controller{
    
    function __construct(){
        parent::__construct();
        $this->load->model('Api_model');
        date_default_timezone_set('America/Costa_Rica');
	}
	
		
	/*----------------------------------------------------------------------------- muestra la política de privacidad del chatBot --------------------------------------------------------------------*/
	
	public function politica_get(){
	    $this->load->view('politicas');
	}
	
	
	public function prueba234234_get(){
	    $this->Api_model->reactivarPlan('50671019839');
	}
	
	
	
	
	/*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	---------------------------------------------- Implementación botframework
	----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/
	

	
	public function getProvincias_get(){
	    try {
	        $provincias=$this->Api_model->getProvincias();
            $output=array();
            foreach($provincias as $provincia){
                $output[]=["nombre"=>$provincia->nombre_provincia,"codigo"=>$provincia->codigo_provincia];
            }
            echo   json_encode(["status"=>200,"options"=>$output]); 
	    } catch (Exception $e) {
	        echo [status=>500,"error"=> "Excepción capturada:{$e->getMessage()}"] ;
	    }
        die();
    }
    
    public function getCantones_post(){
        try {
            $datos=$this->angularpostdata;
            $cantones=$this->Api_model->getCantones($datos->codigoProvincia);
            $output=array();
            foreach($cantones as $canton){
                $output[]=["nombre"=>$canton->nombre_canton,"codigo"=>$canton->codigo_canton]; 
            }
            echo   json_encode(["status"=>200,"options"=>$output]); 
	    } catch (Exception $e) {
	        echo [status=>500,"error"=> "Excepción capturada:{$e->getMessage()}"] ;
	    }
        die();
    }
	
	public function getDistritos_post(){
        try {
            $datos=$this->angularpostdata;
            $distritos=$this->Api_model->getDistritos($datos->codigoCanton);
            $output=array();
            foreach($distritos as $distrito){
                $output[]=["nombre"=>$distrito->nombre_distrito,"codigo"=>$distrito->codigo_distrito]; 
            }
            echo   json_encode(["status"=>200,"options"=>$output]); 
	    } catch (Exception $e) {
	        echo [status=>500,"error"=> "Excepción capturada:{$e->getMessage()}"] ;
	    }
        die();
    }
    
    
    /*------------------------------------------------- Function para validar que la fecha ingresada sea correcta. ----------------------------------------------------------------------------*/

	public function isValidFecha_post(){
	    try {
	        $output=false;
    	    $datos=$this->angularpostdata;
    	    $sugerenciaFecha=date("Y-m-d",strtotime(date('Y-m-d')."+ 18 days"));
    	    $fechaHoy=date('Y/m/d');
    	    $fechaIng=$this->Api_model->cambiarFormatoAMysql2($datos->fecha);
    	    $message='';
    	    if($fechaIng<=$fechaHoy){
    	        $message = "Por favor ingresá una fecha posterior al día de hoy, te sugiero la fecha {$this->Api_model->cambiaf_a_espanol($sugerenciaFecha)}";
            }else if($fechaIng>date("Y/m/d",strtotime($fechaHoy."+ 3 month"))){
                $message = "Es importante que no dejés pasar mucho tiempo. Te recomiendo ingresar una fecha menor o igual a 3 meses posterior al  día de hoy. Te sugiero la fecha {$this->Api_model->cambiaf_a_espanol($sugerenciaFecha)}";
            }else if($this->Api_model->calcularDiferenciaFechas($fechaIng,$fechaHoy)<18){
                 $message = "Yo sé que ya querés comenzar, sin embargo, es necesario que elijás una fecha con al menos 17 días de preparación. Por favor colocá una nueva fecha. Te sugiero la fecha {$this->Api_model->cambiaf_a_espanol($sugerenciaFecha)}";
            }else{
                $output=true;
            }
            echo   json_encode(["status"=>200,"validacion"=>$output,'mensaje'=>$message]); 
	    } catch (Exception $e) {
	        echo [status=>500,"error"=> "Excepción capturada:{$e->getMessage()}"] ;
	    }
	}
	
	/*------------------------------------------------- Funcion que válida y actualiza la fecha del inicio del plan del participante  ----------------------------------------------------------------------------*/

	public function isValidFechaNueva_post()
	{
	    
	    try {
	        $output=false;
    	    $datos=$this->angularpostdata;
    	    $sugerenciaFecha=date("Y-m-d",strtotime(date('Y-m-d')."+ 1 days"));
    	    $fechaHoy=date('Y/m/d');
    	    $fechaIng=$this->Api_model->cambiarFormatoAMysql2($datos->fecha);
    	    $message='';
    	    if($fechaIng<=$fechaHoy){
    	        $message = "Por favor ingresá una fecha posterior al día de hoy, te sugiero la fecha {$this->Api_model->cambiaf_a_espanol($sugerenciaFecha)}";
            }else if($fechaIng>date("Y/m/d",strtotime($fechaHoy."+ 3 month"))){
                $message = "Es importante que no dejés pasar mucho tiempo. Te recomiendo ingresar una fecha menor o igual a 3 meses posterior al  día de hoy. Te sugiero la fecha {$this->Api_model->cambiaf_a_espanol($sugerenciaFecha)}";
            }else{
                $output=$this->Api_model->updateFechaInicioPlan($fechaIng,$datos->user_id);
            }
            echo json_encode(["status"=>200,"validacion"=>$output,"mensaje"=>$message]); 
	    } catch (Exception $e) {
	        echo [status=>500,"error"=> "Excepción capturada:{$e->getMessage()}"] ;
	    }
	}
	
	/*-------------------------------------------------------------------- Function para agregar los participantes --------------------------------------------------------------------------------------*/
	
	 public function addParticipante_post()
	 { 
	    try {
    	    $datos=$this->angularpostdata;
    	    $this->Api_model->addParticipante($datos);
            echo   json_encode(["status"=>200]); 
	    } catch (Exception $e) {
	        echo [status=>500,"error"=> "Excepción capturada:{$e->getMessage()}"] ;
	    }
	 }
	
	/*-------------------------------------------- esta funcion permite agregar sugerencias---------------------------------------------------------------------------------*/
    
    public function addSugerencia_post(){
         try {
             $datos=$this->angularpostdata;
             $this->Api_model->addSugerencia($datos);
             echo   json_encode(["status"=>200]); 
	    } catch (Exception $e) {
	        echo [status=>500,"error"=> "Excepción capturada:{$e->getMessage()}"];
	    }
    }
    
    /*-------------------------------------------- Verificar si existe un usuario registrado  ---------------------------------------------------------------------------------*/
    
    public function verificarRegistroUser_post(){
         try {
             $datos=$this->angularpostdata;
             $result=$this->Api_model->verificarRegistroUser($datos->user_id);
             echo   json_encode(["status"=>200,"result"=>$result]); 
	    } catch (Exception $e) {
	        echo [status=>500,"error"=> "Excepción capturada:{$e->getMessage()}"];
	    }
    }
    
    
    public function comprobrarDiaActivo_post(){
         try {
             $datos=$this->angularpostdata;
             $result=$this->Api_model->obtenerDiaParticipante($datos->user_id);
             echo   json_encode(["status"=>200,"result"=>$result]); 
	    } catch (Exception $e) {
	        echo [status=>500,"error"=> "Excepción capturada:{$e->getMessage()}"];
	    }
    }
    
    
    public function finalizarDia_post(){
         try {
             $datos=$this->angularpostdata;
             $result=$this->Api_model->finalizarDia($datos);
             if($result > 0){
                 echo   json_encode(["status"=>200,"result"=>$result]); 
                 return;
             }
             echo   json_encode(["status"=>500,"result"=>$result]); 
	    } catch (Exception $e) {
	        echo [status=>500,"error"=> "Excepción capturada:{$e->getMessage()}"];
	    }
    }
    
    /*--------------------------------------- esta función permite verificar que lo que el usuario seleccionó es correcto o no --------------------------------------------------*/
    
    public function verificarRespuestaParticipante_post(){
         try {
             $datos=$this->angularpostdata;
             $opciones=$this->Api_model->obtenerDiaParticipante($datos->user_id);
             $opciones=json_decode($opciones->opciones);
             $datos->respParticipante=strtolower($this->eliminar_tildes($datos->respParticipante));
             if(is_numeric ($datos->respParticipante) && $datos->respParticipante >0 &&  $datos->respParticipante <= sizeof($opciones)){
                 echo json_encode(["status"=>200,"result"=>true,"respOpcion"=>$opciones[$datos->respParticipante-1]]);
                 return;
             }else {
                 foreach($opciones as $key => $opcion){
                     if(strtolower($this->eliminar_tildes($opcion))==$datos->respParticipante){
                         echo   json_encode(["status"=>200,"result"=>true,"respOpcion"=>$opciones[$key]]);
                         return;
                    }
                }
             }
             echo   json_encode(["status"=>200,"result"=>false,"opciones"=>$opciones]); 
	    } catch (Exception $e) {
	        echo [status=>500,"error"=> "Excepción capturada:{$e->getMessage()}"];
	    }
	    die();
    }
    
    
    function eliminar_tildes($cadena){
        
		//Reemplazamos la A y a
		$cadena = str_replace(
		array('Á', 'À', 'Â', 'Ä', 'á', 'à', 'ä', 'â', 'ª'),
		array('A', 'A', 'A', 'A', 'a', 'a', 'a', 'a', 'a'),
		$cadena
		);

		//Reemplazamos la E y e
		$cadena = str_replace(
		array('É', 'È', 'Ê', 'Ë', 'é', 'è', 'ë', 'ê'),
		array('E', 'E', 'E', 'E', 'e', 'e', 'e', 'e'),
		$cadena );

		//Reemplazamos la I y i
		$cadena = str_replace(
		array('Í', 'Ì', 'Ï', 'Î', 'í', 'ì', 'ï', 'î'),
		array('I', 'I', 'I', 'I', 'i', 'i', 'i', 'i'),
		$cadena );

		//Reemplazamos la O y o
		$cadena = str_replace(
		array('Ó', 'Ò', 'Ö', 'Ô', 'ó', 'ò', 'ö', 'ô'),
		array('O', 'O', 'O', 'O', 'o', 'o', 'o', 'o'),
		$cadena );

		//Reemplazamos la U y u
		$cadena = str_replace(
		array('Ú', 'Ù', 'Û', 'Ü', 'ú', 'ù', 'ü', 'û'),
		array('U', 'U', 'U', 'U', 'u', 'u', 'u', 'u'),
		$cadena );

		//Reemplazamos la N, n, C y c
		$cadena = str_replace(
		array('Ñ', 'ñ', 'Ç', 'ç'),
		array('N', 'n', 'C', 'c'),
		$cadena
		);
		
		return $cadena;
	}
	//---------------------------------------------pruebas

	
		public function cambiarParticipanteInactivo_post(){
		 
	    try {
	        $datos=$this->angularpostdata;
	        $hoy=date("Y-m-d",strtotime(date('Y-m-d')."+ 1 days"));
	        $result=$this->Api_model->CambiarDiaNew($datos->user_id,$hoy, $datos->resp_usuario);
            echo   json_encode(["status"=>200,"result"=>$result]); 
	    } catch (Exception $e) {
	        echo [status=>500,"error"=> "Excepción capturada:{$e->getMessage()}"];
	    }
	   die();
	}

	public function verificarUsuarioHistorico_post(){
	    try {
	        $datos=$this->angularpostdata;
	        $result=$this->Api_model->verificarUsuario($datos->user_id);
            echo   json_encode(["status"=>200,"result"=>$result]); 
	    } catch (Exception $e) {
	        echo [status=>500,"error"=> "Excepción capturada:{$e->getMessage()}"];
	    }
	    die();
	    
	}
	public function guardarRespuestaCompletarformulario_post(){
	    try {
	        $datos=$this->angularpostdata;
	        $result=$this->Api_model->insertarRespuestaLlenarForm($datos);
            echo   json_encode(["status"=>200,"result"=>$result]); 
	    } catch (Exception $e) {
	        echo [status=>500,"error"=> "Excepción capturada:{$e->getMessage()}"];
	    }
	    die();
	    
	}
	
	//---------------------------------------------pruebas	
	// ya no se usa
	public function cambiarDiaParticipanteInactivo_post(){
	    try {
	        $datos=$this->angularpostdata;
	        $hoy=date("Y-m-d",strtotime(date('Y-m-d')."+ 1 days"));
	        $result=$this->Api_model->changeDayInactivo($datos->user_id,$hoy);
            echo   json_encode(["status"=>200,"result"=>$result]); 
	    } catch (Exception $e) {
	        echo [status=>500,"error"=> "Excepción capturada:{$e->getMessage()}"];
	    }
	    die();
	}
	
	public function cambiarEstadoParticipante_post(){
	    try {
	        $datos=$this->angularpostdata;
	        $result=$this->Api_model->abandonarPlan($datos->user_id,3);
            echo   json_encode(["status"=>200,"result"=>($result===1?true:false)]); 
	    } catch (Exception $e) {
	        echo [status=>500,"error"=> "Excepción capturada:{$e->getMessage()}"];
	    }
	    die();
	}
	
	
	/*------------------------------------------------------- function para obtener el último día que se le envio un mensaje al usuario ----------------------------------------------------------------------------------------------------*/

    public function getLastDaySend_post(){
	    try {
	        $datos=$this->angularpostdata;
	        $result=$this->Api_model->obtenerDiaParticipante($datos->user_id);
            echo   json_encode(["status"=>200,"result"=>$result]); 
	    } catch (Exception $e) {
	        echo [status=>500,"error"=> "Excepción capturada:{$e->getMessage()}"];
	    }
	    die();
	}
	
	        
    /*------------------------------------------------------- function para posponer el plan por 7 días----------------------------------------------------------------------------------------------------*/
 
    public function posPonerPlan_post()
    {

   	    try {
	        $datos=$this->angularpostdata;
	        $this->Api_model->changeState($datos->user_id,5);
	        $result=$this->Api_model->changeRs($datos->user_id);
            echo   json_encode(["status"=>200,"result"=>1]); 
	    } catch (Exception $e) {
	        echo [status=>500,"error"=> "Excepción capturada:{$e->getMessage()}"];
	    }
	    
	    die();
    }

	 
	 ///probar 
	 public function getEstado_get()
    {
   	   
        //$this->Api_model->changeState("5865991180081398",1);
        
        $data=array('fechaInicioSistema'=>'2021-03-29','diaQ'=>'Q17');
	    $this->db->where("user_id","5865991180081398");
	    $this->db->update("participante",$data);
	    
    }
	 
	 public function changeDia_get(){
	    $data=array('estadoEnvio'=>2);
	    $this->db->where("idMensajeEnviado","56");
	    $this->db->update("mensajesEnviadosParticipantePlan",$data);
	 
	}

	
	public function updateIncompletos_post(){
	   try {
		   $datos=$this->angularpostdata;
		   $this->Api_model->updateIncompletos($datos);
		   echo   json_encode(["status"=>200]); 
	   } catch (Exception $e) {
		   echo [status=>500,"error"=> "Excepción capturada:{$e->getMessage()}"] ;
	   }
	}
  public function guardarRespuestasUltimoDia_post(){
	   try {
		   $datos=$this->angularpostdata;
		   $this->Api_model->guardarRespuestasUltimoDia($datos);
		   echo   json_encode(["status"=>200]); 
	   } catch (Exception $e) {
		   echo [status=>500,"error"=> "Excepción capturada:{$e->getMessage()}"] ;
	   }
	   
	   
	}
 public function guardarMensajeEnviadoSeguimiento_post(){
	   try {
		   $datos=$this->angularpostdata;
		   $this->Api_model->guardarMensajeEnviadoSeguimiento($datos);
		   echo   json_encode(["status"=>200]); 
	   } catch (Exception $e) {
		   echo [status=>500,"error"=> "Excepción capturada:{$e->getMessage()}"] ;
	   }
	   
	   
	}
public function guardarRespuestasSeguimiento_post(){
	   try {
		   $datos=$this->angularpostdata;
		   $this->Api_model->guardarRespuestasSeguimiento($datos);
		   echo   json_encode(["status"=>200]); 
	   } catch (Exception $e) {
		   echo [status=>500,"error"=> "Excepción capturada:{$e->getMessage()}"] ;
	   }
	   
	   
	}
	public function guardarRespuestasSeguimientoPlantillas_post(){
	   try {
		   $datos=$this->angularpostdata;
		   $this->Api_model->guardarRespuestasSeguimientoPlantillas($datos);
		   echo   json_encode(["status"=>200]); 
	   } catch (Exception $e) {
		   echo [status=>500,"error"=> "Excepción capturada:{$e->getMessage()}"] ;
	   }
	   
	   
	}
	 public function comprobrarDiaSeguimiento_post(){
         try {
             $datos=$this->angularpostdata;
             $result=$this->Api_model->comprobrarDiaSeguimiento($datos->user_id);
             echo   json_encode(["status"=>200,"result"=>$result]); 
	    } catch (Exception $e) {
	        echo [status=>500,"error"=> "Excepción capturada:{$e->getMessage()}"];
	    }
    }

    public function actualizarEstadoEnvioAndDiaQ_post(){
	   try {
		   $datos=$this->angularpostdata;
		   $this->Api_model->actualizarEstadoEnvioAndDiaQ($datos);
		   echo   json_encode(["status"=>200]); 
	   } catch (Exception $e) {
		   echo [status=>500,"error"=> "Excepción capturada:{$e->getMessage()}"] ;
	   }
	   
	   
	}
	    public function getMsgEnvioPartipante_post(){
	   try {
		   $datos=$this->angularpostdata;
		    $result=$this->Api_model->getMsgEnvioPartipante($datos->user_id);
		   echo   json_encode(["status"=>200,"result"=>$result]); 
	   } catch (Exception $e) {
		   echo [status=>500,"error"=> "Excepción capturada:{$e->getMessage()}"] ;
	   }
	   
	   
	}
}
?>